/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PermittedTargets
implements PropertyChangeListener {
    private PermittedTargets instance;
    private ShortObjectIdManager shortIdManager;
    private UIObjectsWriter uiObjectsWriter;
    private ManagedObjectManager mom;
    private HashMap taskMap;
    private HashMap managedObjectMap;
    private HashMap mergedTasks;
    private HashMap mergedTasksKeys;
    private HashSet allManagedObjectTasks;
    private HashSet allPermittedTargetShortIds;
    private Object lock = new Object();
    private Worker worker;
    private static final String TRACE_MASKT = "HUIPERTT";
    private static final String TRACE_MASKF = "HUIPERTF";
    private static final String TRACE_MASKD = "HUIPERTD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;

    PermittedTargets(ShortObjectIdManager shortIdManager, UIObjectsWriter writer) {
        Trace.trace(TRACE_MASKF, "-> PermittedTargets.PermittedTargets()");
        this.shortIdManager = shortIdManager;
        this.mom = ManagedObjectManager.getManagedObjectManager();
        this.uiObjectsWriter = writer;
        this.taskMap = new HashMap();
        this.mergedTasks = new HashMap();
        this.mergedTasksKeys = new HashMap();
        this.managedObjectMap = new HashMap();
        this.allManagedObjectTasks = new HashSet();
        this.allPermittedTargetShortIds = new HashSet();
        this.worker = new Worker(this);
        Trace.trace(TRACE_MASKF, "<- PermittedTargets.PermittedTargets()");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKF, "-> PermittedTargets.propertyChangeEvent()");
        WorkData data = new WorkData();
        data.type = 3;
        data.evt = evt;
        this.worker.requestWork(data);
        Trace.trace(TRACE_MASKF, "<- PermittedTargets.propertyChangeEvent()");
    }

    void add(ObjectId objectId) {
        Trace.trace(TRACE_MASKF, "-> PermittedTargets.add()");
        WorkData data = new WorkData();
        data.type = 1;
        data.objectId = objectId;
        this.worker.requestWork(data);
        Trace.trace(TRACE_MASKF, "<- PermittedTargets.add()");
    }

    void remove(ObjectId objectId) {
        Trace.trace(TRACE_MASKF, "-> PermittedTargets.remove()");
        WorkData data = new WorkData();
        data.type = 2;
        data.objectId = objectId;
        this.worker.requestWork(data);
        Trace.trace(TRACE_MASKF, "<- PermittedTargets.remove()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getTaskToObjectMap() {
        Trace.trace(TRACE_MASKF, "-> PermittedTargets.getTaskToObjectMap()");
        HashMap<Object, HashSet> result = new HashMap<Object, HashSet>();
        Object object = this.lock;
        synchronized (object) {
            Iterator<Object> tasks = this.taskMap.keySet().iterator();
            while (tasks.hasNext()) {
                ObjectId taskObjectId = (ObjectId)tasks.next();
                String taskShortId = this.shortIdManager.getShortId(taskObjectId);
                Set permittedTargets = (Set)this.taskMap.get(taskObjectId);
                HashSet<String> permittedTargetShortIds = new HashSet<String>();
                Iterator objs = this.managedObjectMap.keySet().iterator();
                while (objs.hasNext()) {
                    ObjectId objObjectId = (ObjectId)objs.next();
                    String objShortId = this.shortIdManager.getShortId(objObjectId);
                    String targetName = (String)this.managedObjectMap.get(objObjectId);
                    if (!permittedTargets.contains(targetName)) continue;
                    permittedTargetShortIds.add(this.uiObjectsWriter.getShortIdForTarget(objObjectId, targetName));
                }
                result.put(taskShortId, permittedTargetShortIds);
            }
            tasks = this.allManagedObjectTasks.iterator();
            while (tasks.hasNext()) {
                result.put(tasks.next(), this.allPermittedTargetShortIds);
            }
            Iterator iterator = this.mergedTasks.keySet().iterator();
            while (iterator.hasNext()) {
                String taskShortId;
                String mergedKey = (String)iterator.next();
                List theTasks = (List)this.mergedTasks.get(mergedKey);
                HashSet targets = new HashSet();
                Iterator iterator2 = theTasks.iterator();
                while (iterator2.hasNext()) {
                    taskShortId = (String)iterator2.next();
                    targets.addAll((Set)result.get(taskShortId));
                }
                iterator2 = theTasks.iterator();
                while (iterator2.hasNext()) {
                    taskShortId = (String)iterator2.next();
                    Set targetShortIds = (Set)result.get(taskShortId);
                    targetShortIds.clear();
                    targetShortIds.addAll(targets);
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- PermittedTargets.getTaskToObjectMap()");
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WorkData {
        static final int ADD = 1;
        static final int REMOVE = 2;
        static final int CHANGE = 3;
        int type;
        ObjectId objectId;
        PropertyChangeEvent evt;

        private WorkData() {
        }
    }

    private class Worker
    implements WorkPerformer,
    WorkListener {
        private WorkThread workThread;
        private PermittedTargets instance;

        public Worker(PermittedTargets instance) {
            this.instance = instance;
            this.workThread = new WorkThread("PermittedObjects.Worker");
            this.workThread.startWorker();
        }

        public void requestWork(WorkData data) {
            this.workThread.requestWork(this, this, "WorkData", data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object performWork(Object data) {
            Trace.trace(PermittedTargets.TRACE_MASKT, "-> PermittedObjects.Worker.performWork()");
            Object object = PermittedTargets.this.lock;
            synchronized (object) {
                WorkData workData = (WorkData)data;
                switch (workData.type) {
                    case 1: {
                        this.add(workData.objectId);
                        break;
                    }
                    case 2: {
                        this.remove(workData.objectId);
                        break;
                    }
                    case 3: {
                        this.change(workData.evt);
                    }
                }
            }
            Trace.trace(PermittedTargets.TRACE_MASKT, "<- PermittedObjects.Worker.performWork()");
            return null;
        }

        public void workCompleted(WorkEvent event) {
            Trace.trace(PermittedTargets.TRACE_MASKT, " <> PermittedTargets.Worker.workCompleted()");
        }

        private void add(ObjectId objectId) {
            if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = PermittedTargets.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task)) {
                Task task = (Task)PermittedTargets.this.mom.get(objectId);
                task.addPropertyChangeListener("PermittedObjects", this.instance);
                if (task.isAnyPermitted()) {
                    PermittedTargets.this.allManagedObjectTasks.add(PermittedTargets.this.shortIdManager.getShortId(objectId));
                    Trace.trace(PermittedTargets.TRACE_MASKT, "all targets allowed for task shortId " + PermittedTargets.this.shortIdManager.getShortId(objectId));
                } else {
                    PermittedTargets.this.taskMap.put(objectId, task.getPermittedObjects());
                    String mergedKey = (String)PermittedTargets.this.mom.getProperty(objectId, "MergedKey");
                    if (mergedKey != null) {
                        PermittedTargets.this.mergedTasksKeys.put(objectId, mergedKey);
                        ArrayList<String> taskObjectIds = (ArrayList<String>)PermittedTargets.this.mergedTasks.get(mergedKey);
                        if (taskObjectIds == null) {
                            taskObjectIds = new ArrayList<String>();
                            PermittedTargets.this.mergedTasks.put(mergedKey, taskObjectIds);
                        }
                        taskObjectIds.add(PermittedTargets.this.shortIdManager.getShortId(objectId));
                    }
                }
            } else if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = PermittedTargets.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                String targetName = (String)PermittedTargets.this.mom.getProperty(objectId, "TargetId");
                PermittedTargets.this.allPermittedTargetShortIds.add(PermittedTargets.this.uiObjectsWriter.getShortIdForTarget(objectId, targetName));
                PermittedTargets.this.managedObjectMap.put(objectId, targetName);
            } else if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectGroup = PermittedTargets.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup")) : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                PermittedTargets.this.managedObjectMap.put(objectId, objectId.getFullClassName());
            }
        }

        private void remove(ObjectId objectId) {
            if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = PermittedTargets.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task)) {
                PermittedTargets.this.mom.removePropertyChangeListener(objectId, "PermittedObjects", this.instance);
                PermittedTargets.this.taskMap.remove(objectId);
                PermittedTargets.this.allManagedObjectTasks.remove(objectId);
                String mergedKey = (String)PermittedTargets.this.mergedTasksKeys.remove(objectId);
                if (mergedKey != null) {
                    PermittedTargets.this.mergedTasks.remove(mergedKey);
                }
            } else if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = PermittedTargets.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                PermittedTargets.this.managedObjectMap.remove(objectId);
            } else if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectGroup = PermittedTargets.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup")) : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                PermittedTargets.this.managedObjectMap.remove(objectId);
            }
        }

        private void change(PropertyChangeEvent evt) {
            ObjectId objectId = (ObjectId)evt.getSource();
            PermittedTargets.this.taskMap.put(objectId, PermittedTargets.this.mom.getProperty(objectId, "PermittedObjects"));
        }
    }
}

